# TaskPlanner: Log Action Plugin

This readme describes how to use the sample to create a custom Task Planner action that is able to log the text results from jobs in a logger that can be defined in the task.

## Activate the included plugin

A compiled version of the plugin is made available as `taskplanner.logaction.sample.zip`. In order to test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details. The Logging action is now available in the Task Planner action selection.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some modifications, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `taskplanner.jar` (included in `plugins/taskplanner.zip`) 

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `taskplanner.logaction.sample.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `taskplanner.logaction.sample.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configure the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin as well as any other build system.

